﻿//////////////////////////////////////////////
// EntityRenderInfo.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Entity ;
	class Mesh ;
	class Shader ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "EntityRenderInfoSlot.h"

// nkExport
#include <NilkinsExport/Exportable/Exportable.h>

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT EntityRenderInfo final : public nkExport::Exportable
	{
		public :

			// Constructor, destructor
			EntityRenderInfo () noexcept ;
			EntityRenderInfo (const EntityRenderInfo& other) noexcept ;
			EntityRenderInfo (EntityRenderInfo&& other) noexcept ;
			EntityRenderInfo (Mesh* mesh, Shader* shader) noexcept ;
			virtual ~EntityRenderInfo () ;

			// Getters
			EntityRenderInfoSlot* getSlot (unsigned int index) const ;
			const nkMemory::BufferCast<EntityRenderInfoSlot*>& getSlots () const ;
			Entity* getParentEntity () const ;

			// Manipulations
			EntityRenderInfoSlot* addSlot (const EntityRenderInfoSlot& infoSlot = EntityRenderInfoSlot()) ;
			void eraseSlot (unsigned int index) ;

			// Operators
			EntityRenderInfo& operator= (const EntityRenderInfo& other) noexcept ;
			EntityRenderInfo& operator= (EntityRenderInfo&& other) noexcept ;

			// Import / Export
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		private :

			// Functions
			// Setters
			void _setParentEntity (Entity* entity) ;

		private :

			// Attributes
			nkMemory::BufferCast<EntityRenderInfoSlot*> _slots ;

			Entity* _parentEntity ;

		private :

			friend class Entity ;
	} ;
}